/*
 * Decompiled with CFR 0.152.
 */
package gg.hyservers.plugin.util;

import gg.hyservers.plugin.libs.gson.Gson;
import gg.hyservers.plugin.libs.gson.JsonElement;
import gg.hyservers.plugin.libs.gson.JsonObject;
import gg.hyservers.plugin.libs.gson.JsonParser;
import gg.hyservers.plugin.network.ProtocolConstants;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class HmacUtil {
    private static final Gson GSON = new Gson();

    private HmacUtil() {
    }

    public static boolean validate(String jsonPayload, String secret) {
        try {
            JsonObject json = JsonParser.parseString(jsonPayload).getAsJsonObject();
            JsonElement sigElement = json.get("signature");
            if (sigElement == null || sigElement.isJsonNull()) {
                return false;
            }
            String providedSignature = sigElement.getAsString();
            json.remove("signature");
            json.remove("reward");
            String canonical = HmacUtil.canonicalize(json);
            String computed = HmacUtil.computeHmac(canonical, secret);
            return MessageDigest.isEqual(providedSignature.getBytes(ProtocolConstants.PAYLOAD_CHARSET), computed.getBytes(ProtocolConstants.PAYLOAD_CHARSET));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String computeHmac(String data, String secret) throws Exception {
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec keySpec = new SecretKeySpec(secret.getBytes(ProtocolConstants.PAYLOAD_CHARSET), "HmacSHA256");
        mac.init(keySpec);
        byte[] hash = mac.doFinal(data.getBytes(ProtocolConstants.PAYLOAD_CHARSET));
        return Base64.getEncoder().encodeToString(hash);
    }

    private static String canonicalize(JsonObject json) {
        JsonObject canonical = HmacUtil.sortJsonObject(json);
        return GSON.toJson(canonical);
    }

    private static JsonObject sortJsonObject(JsonObject json) {
        TreeMap<String, JsonElement> sorted = new TreeMap<String, JsonElement>();
        for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
            JsonElement value = entry.getValue();
            if (value.isJsonObject()) {
                sorted.put(entry.getKey(), HmacUtil.sortJsonObject(value.getAsJsonObject()));
                continue;
            }
            sorted.put(entry.getKey(), value);
        }
        JsonObject result = new JsonObject();
        sorted.forEach(result::add);
        return result;
    }
}

