/*
 * Decompiled with CFR 0.152.
 */
package gg.hyservers.plugin.rewards;

import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandManager;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.console.ConsoleSender;
import com.hypixel.hytale.server.core.entity.entities.Player;
import gg.hyservers.plugin.config.PluginConfig;
import gg.hyservers.plugin.libs.gson.JsonArray;
import gg.hyservers.plugin.libs.gson.JsonObject;
import gg.hyservers.plugin.rewards.OfflineQueue;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RewardExecutor {
    private final PluginConfig config;
    private final OfflineQueue offlineQueue;
    private final HytaleLogger logger;
    private final ConcurrentHashMap<String, Player> onlinePlayers = new ConcurrentHashMap();
    private static final String COLOR_EMERALD = "#10b981";
    private static final String COLOR_EMERALD_LT = "#34d399";
    private static final String COLOR_GOLD = "#fbbf24";
    private static final String COLOR_GOLD_LT = "#fde68a";
    private static final String COLOR_CYAN = "#22d3ee";
    private static final String COLOR_PURPLE = "#a78bfa";
    private static final String COLOR_PURPLE_LT = "#c4b5fd";
    private static final String COLOR_WHITE = "#f8fafc";
    private static final String COLOR_MUTED = "#94a3b8";
    private static final String COLOR_ROSE = "#fb7185";
    private static final String COLOR_AMBER = "#f59e0b";

    public RewardExecutor(PluginConfig config, OfflineQueue offlineQueue, HytaleLogger logger) {
        this.config = config;
        this.offlineQueue = offlineQueue;
        this.logger = logger;
    }

    public void trackPlayer(Player player) {
        this.onlinePlayers.put(player.getDisplayName().toLowerCase(), player);
    }

    public void untrackPlayer(String playerName) {
        this.onlinePlayers.remove(playerName.toLowerCase());
    }

    public void processVote(String playerName, JsonObject rewardData) {
        if (!this.config.isVoteAcknowledge()) {
            if (this.config.isDebug()) {
                ((HytaleLogger.Api)this.logger.atInfo()).log("Vote acknowledgment disabled, skipping rewards for %s", (Object)playerName);
            }
            return;
        }
        Player player = this.findOnlinePlayer(playerName);
        if (player != null) {
            this.deliverVoteReward(playerName, player, rewardData);
        } else {
            boolean queued = this.offlineQueue.enqueue(playerName, new OfflineQueue.QueuedReward("vote", System.currentTimeMillis(), 0));
            if (queued) {
                ((HytaleLogger.Api)this.logger.atInfo()).log("Queued vote reward for offline player: %s", (Object)playerName);
            }
        }
    }

    public void processReview(String playerName, int rating) {
        if (!this.config.isReviewAcknowledge()) {
            if (this.config.isDebug()) {
                ((HytaleLogger.Api)this.logger.atInfo()).log("Review acknowledgment disabled, skipping rewards for %s", (Object)playerName);
            }
            return;
        }
        Player player = this.findOnlinePlayer(playerName);
        if (player != null) {
            this.deliverReviewReward(playerName, player, rating);
        } else {
            boolean queued = this.offlineQueue.enqueue(playerName, new OfflineQueue.QueuedReward("review", System.currentTimeMillis(), rating));
            if (queued) {
                ((HytaleLogger.Api)this.logger.atInfo()).log("Queued review reward for offline player: %s", (Object)playerName);
            }
        }
    }

    public void deliverPending(String playerName) {
        List<OfflineQueue.QueuedReward> pending = this.offlineQueue.drain(playerName);
        if (pending.isEmpty()) {
            return;
        }
        Player player = this.findOnlinePlayer(playerName);
        if (player == null) {
            for (OfflineQueue.QueuedReward reward : pending) {
                this.offlineQueue.enqueue(playerName, reward);
            }
            return;
        }
        ((HytaleLogger.Api)this.logger.atInfo()).log("Delivering %d queued reward(s) to %s", pending.size(), (Object)playerName);
        block9: for (OfflineQueue.QueuedReward reward : pending) {
            switch (reward.type()) {
                case "vote": {
                    this.deliverVoteReward(playerName, player, null);
                    continue block9;
                }
                case "review": {
                    this.deliverReviewReward(playerName, player, reward.rating());
                    continue block9;
                }
            }
            ((HytaleLogger.Api)this.logger.atWarning()).log("Unknown reward type in queue: %s", (Object)reward.type());
        }
    }

    private void deliverVoteReward(String playerName, Player player, JsonObject rewardData) {
        Map<String, String> placeholders = Map.of("{player}", playerName, "{service}", "HyServers.gg");
        if (rewardData != null) {
            this.deliverWebsiteReward(playerName, player, rewardData, placeholders);
        } else {
            this.executeCommands(this.config.getVoteCommands(), placeholders);
        }
        this.sendStyledMessage(player, this.config.getVoteMessage(), placeholders, COLOR_GOLD);
        if (this.config.isBroadcastVotes()) {
            this.broadcastVote(playerName);
        }
        ((HytaleLogger.Api)this.logger.atInfo()).log("Delivered vote reward to %s", (Object)playerName);
    }

    private void deliverWebsiteReward(String playerName, Player player, JsonObject reward, Map<String, String> placeholders) {
        int quantity;
        String rewardType = reward.has("reward_type") ? reward.get("reward_type").getAsString() : "item";
        String displayName = reward.has("display_name") && !reward.get("display_name").isJsonNull() ? reward.get("display_name").getAsString() : null;
        int n = quantity = reward.has("quantity") ? reward.get("quantity").getAsInt() : 1;
        if ("item".equals(rewardType)) {
            String itemId;
            String string = itemId = reward.has("item_id") && !reward.get("item_id").isJsonNull() ? reward.get("item_id").getAsString() : null;
            if (itemId != null) {
                String giveCmd = quantity > 1 ? "give " + playerName + " " + itemId + " --quantity=" + quantity : "give " + playerName + " " + itemId;
                try {
                    CommandManager.get().handleCommand((CommandSender)ConsoleSender.INSTANCE, giveCmd);
                }
                catch (Exception e) {
                    ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("Failed to give item: %s", (Object)giveCmd);
                }
                String name = displayName != null ? displayName : itemId;
                Object qtyText = quantity > 1 ? quantity + "x " : "";
                this.sendRichMessage(player, Message.join((Message[])new Message[]{Message.raw((String)"+ ").color(COLOR_GOLD).bold(true), Message.raw((String)"You received ").color(COLOR_WHITE), Message.raw((String)qtyText).color(COLOR_GOLD_LT).bold(true), RewardExecutor.gradient(name, COLOR_GOLD, COLOR_GOLD_LT).bold(true), Message.raw((String)"!").color(COLOR_WHITE)}));
            }
        } else if ("custom".equals(rewardType)) {
            if (reward.has("commands") && reward.get("commands").isJsonArray()) {
                JsonArray cmds = reward.getAsJsonArray("commands");
                for (int i = 0; i < cmds.size(); ++i) {
                    String cmd = cmds.get(i).getAsString();
                    String resolved = this.replacePlaceholders(cmd, placeholders);
                    try {
                        CommandManager.get().handleCommand((CommandSender)ConsoleSender.INSTANCE, resolved);
                        continue;
                    }
                    catch (Exception e) {
                        ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("Failed to execute reward command: %s", (Object)resolved);
                    }
                }
            }
            if (displayName != null) {
                this.sendRichMessage(player, Message.join((Message[])new Message[]{Message.raw((String)"+ ").color(COLOR_GOLD).bold(true), Message.raw((String)"You received ").color(COLOR_WHITE), RewardExecutor.gradient(displayName, COLOR_GOLD, COLOR_GOLD_LT).bold(true), Message.raw((String)"!").color(COLOR_WHITE)}));
            }
        }
    }

    private void deliverReviewReward(String playerName, Player player, int rating) {
        Map<String, String> placeholders = Map.of("{player}", playerName, "{rating}", String.valueOf(rating), "{service}", "HyServers.gg");
        this.executeCommands(this.config.getReviewCommands(), placeholders);
        String stars = "*".repeat(Math.max(1, Math.min(rating, 5)));
        this.sendRichMessage(player, Message.join((Message[])new Message[]{Message.raw((String)"* ").color(COLOR_GOLD).bold(true), Message.raw((String)"Thanks for your review! ").color(COLOR_WHITE), RewardExecutor.gradient(stars, COLOR_GOLD, COLOR_GOLD_LT).bold(true)}));
        ((HytaleLogger.Api)this.logger.atInfo()).log("Delivered review reward to %s (rating: %d)", (Object)playerName, rating);
    }

    private void executeCommands(String[] commands, Map<String, String> placeholders) {
        if (commands == null || commands.length == 0) {
            return;
        }
        for (String template : commands) {
            String command = this.replacePlaceholders(template, placeholders);
            try {
                CommandManager.get().handleCommand((CommandSender)ConsoleSender.INSTANCE, command);
            }
            catch (Exception e) {
                ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("Failed to execute command: %s", (Object)command);
            }
        }
    }

    private void sendStyledMessage(Player player, String messageTemplate, Map<String, String> placeholders, String color) {
        if (messageTemplate == null || messageTemplate.isEmpty()) {
            return;
        }
        String text = this.replacePlaceholders(messageTemplate, placeholders);
        try {
            player.sendMessage(Message.raw((String)text).color(color));
        }
        catch (Exception e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("Failed to send message to %s", (Object)player.getDisplayName());
        }
    }

    private void sendRichMessage(Player player, Message message) {
        try {
            player.sendMessage(message);
        }
        catch (Exception e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("Failed to send rich message to %s", (Object)player.getDisplayName());
        }
    }

    private void broadcastVote(String playerName) {
        String template = this.config.getBroadcastMessage();
        if (template == null || template.isEmpty()) {
            return;
        }
        try {
            Message msg = Message.join((Message[])new Message[]{Message.raw((String)">> ").color(COLOR_GOLD).bold(true), RewardExecutor.gradient(playerName, COLOR_GOLD, COLOR_GOLD_LT).bold(true), Message.raw((String)" just voted on ").color(COLOR_MUTED), Message.raw((String)"HyServers.gg").color(COLOR_GOLD).bold(true).link(this.config.getVoteUrl()), Message.raw((String)"!").color(COLOR_MUTED)});
            for (Player p : this.onlinePlayers.values()) {
                p.sendMessage(msg);
            }
        }
        catch (Exception e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("Failed to broadcast vote message");
        }
    }

    private static Message gradient(String text, String hexFrom, String hexTo) {
        if (text.length() <= 1) {
            return Message.raw((String)text).color(hexFrom);
        }
        int r1 = Integer.parseInt(hexFrom.substring(1, 3), 16);
        int g1 = Integer.parseInt(hexFrom.substring(3, 5), 16);
        int b1 = Integer.parseInt(hexFrom.substring(5, 7), 16);
        int r2 = Integer.parseInt(hexTo.substring(1, 3), 16);
        int g2 = Integer.parseInt(hexTo.substring(3, 5), 16);
        int b2 = Integer.parseInt(hexTo.substring(5, 7), 16);
        Message[] chars = new Message[text.length()];
        int last = text.length() - 1;
        for (int i = 0; i < text.length(); ++i) {
            float ratio = (float)i / (float)last;
            int r = Math.round((float)r1 + (float)(r2 - r1) * ratio);
            int g = Math.round((float)g1 + (float)(g2 - g1) * ratio);
            int b = Math.round((float)b1 + (float)(b2 - b1) * ratio);
            String hex = String.format("#%02x%02x%02x", r, g, b);
            chars[i] = Message.raw((String)String.valueOf(text.charAt(i))).color(hex);
        }
        return Message.join((Message[])chars);
    }

    public int getOnlinePlayerCount() {
        return this.onlinePlayers.size();
    }

    private String replacePlaceholders(String template, Map<String, String> placeholders) {
        String result = template;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private Player findOnlinePlayer(String playerName) {
        return this.onlinePlayers.get(playerName.toLowerCase());
    }
}

