/*
 * Decompiled with CFR 0.152.
 */
package gg.hyservers.plugin.rewards;

import com.hypixel.hytale.logger.HytaleLogger;
import gg.hyservers.plugin.libs.gson.Gson;
import gg.hyservers.plugin.libs.gson.GsonBuilder;
import gg.hyservers.plugin.libs.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OfflineQueue {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type QUEUE_TYPE = new TypeToken<Map<String, List<QueuedReward>>>(){}.getType();
    private final ConcurrentHashMap<String, List<QueuedReward>> queue = new ConcurrentHashMap();
    private final Path filePath;
    private final int maxQueueSize;
    private final int expiryHours;
    private final HytaleLogger logger;

    public OfflineQueue(Path pluginDataDir, int maxQueueSize, int expiryHours, HytaleLogger logger) {
        this.filePath = pluginDataDir.resolve("queued_rewards.json");
        this.maxQueueSize = maxQueueSize;
        this.expiryHours = expiryHours;
        this.logger = logger;
    }

    public void load() {
        if (!Files.exists(this.filePath, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.filePath);){
            Map loaded = (Map)GSON.fromJson((Reader)reader, QUEUE_TYPE);
            if (loaded != null) {
                loaded.forEach((player, rewards) -> this.queue.put(player.toLowerCase(), new ArrayList(rewards)));
            }
            ((HytaleLogger.Api)this.logger.atInfo()).log("Loaded %d queued reward(s) for %d player(s)", this.totalSize(), this.queue.size());
        }
        catch (IOException e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("Failed to load offline queue");
        }
    }

    public void save() {
        try {
            Files.createDirectories(this.filePath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.filePath, new OpenOption[0]);){
                GSON.toJson(this.queue, QUEUE_TYPE, writer);
            }
        }
        catch (IOException e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("Failed to save offline queue");
        }
    }

    public boolean enqueue(String playerName, QueuedReward reward) {
        if (this.totalSize() >= this.maxQueueSize) {
            ((HytaleLogger.Api)this.logger.atWarning()).log("Offline queue is full (%d), dropping reward for %s", this.maxQueueSize, (Object)playerName);
            return false;
        }
        String key = playerName.toLowerCase();
        this.queue.computeIfAbsent(key, k -> Collections.synchronizedList(new ArrayList())).add(reward);
        return true;
    }

    public List<QueuedReward> drain(String playerName) {
        List<QueuedReward> rewards = this.queue.remove(playerName.toLowerCase());
        return rewards != null ? rewards : List.of();
    }

    public boolean hasPending(String playerName) {
        List<QueuedReward> rewards = this.queue.get(playerName.toLowerCase());
        return rewards != null && !rewards.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cleanExpired() {
        long cutoff = System.currentTimeMillis() - (long)this.expiryHours * 3600000L;
        int removed = 0;
        Iterator<Map.Entry<String, List<QueuedReward>>> it = this.queue.entrySet().iterator();
        while (it.hasNext()) {
            List<QueuedReward> rewards;
            Map.Entry<String, List<QueuedReward>> entry = it.next();
            List<QueuedReward> list = rewards = entry.getValue();
            synchronized (list) {
                int before = rewards.size();
                rewards.removeIf(r -> r.timestamp() < cutoff);
                removed += before - rewards.size();
                if (rewards.isEmpty()) {
                    it.remove();
                }
            }
        }
        if (removed > 0) {
            ((HytaleLogger.Api)this.logger.atInfo()).log("Cleaned %d expired reward(s) from offline queue", removed);
        }
        return removed;
    }

    private int totalSize() {
        return this.queue.values().stream().mapToInt(List::size).sum();
    }

    public record QueuedReward(String type, long timestamp, int rating) {
    }
}

