/*
 * Decompiled with CFR 0.152.
 */
package gg.hyservers.plugin.network;

import com.hypixel.hytale.logger.HytaleLogger;
import gg.hyservers.plugin.config.PluginConfig;
import gg.hyservers.plugin.libs.gson.Gson;
import gg.hyservers.plugin.rewards.RewardExecutor;
import gg.hyservers.plugin.util.HmacUtil;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class StatusPinger {
    private static final Gson GSON = new Gson();
    private final PluginConfig config;
    private final RewardExecutor rewardExecutor;
    private final HytaleLogger logger;
    private final HttpClient httpClient;
    private ScheduledFuture<?> task;

    public StatusPinger(PluginConfig config, RewardExecutor rewardExecutor, HytaleLogger logger) {
        this.config = config;
        this.rewardExecutor = rewardExecutor;
        this.logger = logger;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    public void start(ScheduledExecutorService scheduler) {
        int interval = this.config.getStatusPingIntervalSeconds();
        this.task = scheduler.scheduleAtFixedRate(this::ping, 30L, interval, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel(false);
        }
    }

    private void ping() {
        try {
            String timestamp = Instant.now().toString();
            TreeMap<String, Object> payload = new TreeMap<String, Object>();
            payload.put("max_players", this.config.getMaxPlayers());
            payload.put("motd", this.config.getServerMotd());
            payload.put("online_players", this.rewardExecutor.getOnlinePlayerCount());
            payload.put("server_version", this.config.getServerVersion());
            payload.put("timestamp", timestamp);
            String canonical = GSON.toJson(payload);
            String signature = HmacUtil.computeHmac(canonical, this.config.getSharedSecret());
            payload.put("signature", signature);
            String body = GSON.toJson(payload);
            String url = this.config.getApiBaseUrl().replaceAll("/$", "") + "/api/v1/servers/" + this.config.getServerId() + "/plugin-status";
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body)).timeout(Duration.ofSeconds(15L)).build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            int status = response.statusCode();
            if (status == 200) {
                if (this.config.isDebug()) {
                    ((HytaleLogger.Api)this.logger.atInfo()).log("[StatusPing] Success (%d players online)", this.rewardExecutor.getOnlinePlayerCount());
                }
            } else if (status == 429) {
                ((HytaleLogger.Api)this.logger.atWarning()).log("[StatusPing] Rate limited (429) \u2014 will retry at next interval");
            } else if (status == 401) {
                ((HytaleLogger.Api)this.logger.atSevere()).log("[StatusPing] Authentication failed (401) \u2014 check that SharedSecret matches your server's config on HyServers.gg");
            } else if (status == 404) {
                ((HytaleLogger.Api)this.logger.atWarning()).log("[StatusPing] Server not found (404) \u2014 check that ServerId is correct");
            } else {
                String respBody = response.body();
                if (respBody != null && (respBody.contains("<html") || respBody.length() > 200)) {
                    respBody = null;
                }
                ((HytaleLogger.Api)this.logger.atWarning()).log("[StatusPing] Unexpected response: %d%s", status, respBody != null ? " \u2014 " + respBody : "");
            }
        }
        catch (Exception e) {
            if (this.config.isDebug()) {
                ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("[StatusPing] Failed to send status ping");
            }
            ((HytaleLogger.Api)this.logger.atWarning()).log("[StatusPing] Failed to send status ping: %s", (Object)e.getMessage());
        }
    }
}

