/*
 * Decompiled with CFR 0.152.
 */
package gg.hyservers.plugin.network;

import com.hypixel.hytale.logger.HytaleLogger;
import gg.hyservers.plugin.config.PluginConfig;
import gg.hyservers.plugin.libs.gson.Gson;
import gg.hyservers.plugin.libs.gson.JsonArray;
import gg.hyservers.plugin.libs.gson.JsonElement;
import gg.hyservers.plugin.libs.gson.JsonObject;
import gg.hyservers.plugin.libs.gson.JsonParser;
import gg.hyservers.plugin.rewards.RewardExecutor;
import gg.hyservers.plugin.util.HmacUtil;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class PendingRewardPoller {
    private static final Gson GSON = new Gson();
    private final PluginConfig config;
    private final RewardExecutor rewardExecutor;
    private final HytaleLogger logger;
    private final HttpClient httpClient;
    private ScheduledFuture<?> task;

    public PendingRewardPoller(PluginConfig config, RewardExecutor rewardExecutor, HytaleLogger logger) {
        this.config = config;
        this.rewardExecutor = rewardExecutor;
        this.logger = logger;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    public void start(ScheduledExecutorService scheduler) {
        int interval = this.config.getStatusPingIntervalSeconds();
        this.task = scheduler.scheduleAtFixedRate(this::poll, 60L, interval, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel(false);
        }
    }

    private void poll() {
        try {
            JsonArray pending = this.fetchPendingRewards();
            if (pending == null || pending.isEmpty()) {
                if (this.config.isDebug()) {
                    ((HytaleLogger.Api)this.logger.atInfo()).log("[PendingRewardPoller] No pending rewards");
                }
                return;
            }
            if (this.config.isDebug()) {
                ((HytaleLogger.Api)this.logger.atInfo()).log("[PendingRewardPoller] Received %d pending reward(s)", pending.size());
            }
            ArrayList<String> confirmedVoteIds = new ArrayList<String>();
            for (JsonElement element : pending) {
                JsonObject vote = element.getAsJsonObject();
                String voteId = vote.get("vote_id").getAsString();
                String username = vote.get("username").getAsString();
                JsonObject rewardData = null;
                if (vote.has("reward") && !vote.get("reward").isJsonNull()) {
                    rewardData = vote.getAsJsonObject("reward");
                }
                try {
                    this.rewardExecutor.processVote(username, rewardData);
                    confirmedVoteIds.add(voteId);
                }
                catch (Exception e) {
                    ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("[PendingRewardPoller] Failed to process reward for %s (vote_id: %s)", (Object)username, (Object)voteId);
                }
            }
            if (!confirmedVoteIds.isEmpty()) {
                this.confirmRewards(confirmedVoteIds);
            }
        }
        catch (Exception e) {
            if (this.config.isDebug()) {
                ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("[PendingRewardPoller] Poll cycle failed");
            }
            ((HytaleLogger.Api)this.logger.atWarning()).log("[PendingRewardPoller] Poll cycle failed: %s", (Object)e.getMessage());
        }
    }

    private JsonArray fetchPendingRewards() throws Exception {
        String timestamp = Instant.now().toString();
        TreeMap<String, String> payload = new TreeMap<String, String>();
        payload.put("timestamp", timestamp);
        String canonical = GSON.toJson(payload);
        String signature = HmacUtil.computeHmac(canonical, this.config.getSharedSecret());
        payload.put("signature", signature);
        String body = GSON.toJson(payload);
        String url = this.config.getApiBaseUrl().replaceAll("/$", "") + "/api/v1/servers/" + this.config.getServerId() + "/pending-rewards";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body)).timeout(Duration.ofSeconds(15L)).build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        int status = response.statusCode();
        if (status == 200) {
            JsonObject json = JsonParser.parseString(response.body()).getAsJsonObject();
            if (json.has("pending") && json.get("pending").isJsonArray()) {
                return json.getAsJsonArray("pending");
            }
            return null;
        }
        if (status == 401) {
            ((HytaleLogger.Api)this.logger.atSevere()).log("[PendingRewardPoller] Authentication failed (401) \u2014 check that SharedSecret matches your server's config on HyServers.gg");
        } else if (status == 404) {
            ((HytaleLogger.Api)this.logger.atWarning()).log("[PendingRewardPoller] Server not found (404) \u2014 check that ServerId is correct");
        } else if (status == 429) {
            ((HytaleLogger.Api)this.logger.atWarning()).log("[PendingRewardPoller] Rate limited (429) \u2014 will retry at next interval");
        } else {
            String respBody = response.body();
            if (respBody != null && (respBody.contains("<html") || respBody.length() > 200)) {
                respBody = null;
            }
            ((HytaleLogger.Api)this.logger.atWarning()).log("[PendingRewardPoller] Unexpected response from pending-rewards: %d%s", status, respBody != null ? " \u2014 " + respBody : "");
        }
        return null;
    }

    private void confirmRewards(List<String> voteIds) {
        try {
            String timestamp = Instant.now().toString();
            TreeMap<String, Object> payload = new TreeMap<String, Object>();
            payload.put("timestamp", timestamp);
            payload.put("vote_ids", voteIds);
            String canonical = GSON.toJson(payload);
            String signature = HmacUtil.computeHmac(canonical, this.config.getSharedSecret());
            payload.put("signature", signature);
            String body = GSON.toJson(payload);
            String url = this.config.getApiBaseUrl().replaceAll("/$", "") + "/api/v1/servers/" + this.config.getServerId() + "/confirm-rewards";
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body)).timeout(Duration.ofSeconds(15L)).build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            int status = response.statusCode();
            if (status == 200) {
                ((HytaleLogger.Api)this.logger.atInfo()).log("[PendingRewardPoller] Confirmed %d reward(s)", voteIds.size());
            } else {
                String respBody = response.body();
                if (respBody != null && (respBody.contains("<html") || respBody.length() > 200)) {
                    respBody = null;
                }
                ((HytaleLogger.Api)this.logger.atWarning()).log("[PendingRewardPoller] Failed to confirm rewards: %d%s", status, respBody != null ? " \u2014 " + respBody : "");
            }
        }
        catch (Exception e) {
            if (this.config.isDebug()) {
                ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("[PendingRewardPoller] Failed to confirm rewards");
            }
            ((HytaleLogger.Api)this.logger.atWarning()).log("[PendingRewardPoller] Failed to confirm rewards: %s", (Object)e.getMessage());
        }
    }
}

