/*
 * Decompiled with CFR 0.152.
 */
package gg.hyservers.plugin.network;

import com.hypixel.hytale.logger.HytaleLogger;
import gg.hyservers.plugin.config.PluginConfig;
import gg.hyservers.plugin.rewards.RewardExecutor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class HyQueryResponder {
    private static final byte[] REQUEST_MAGIC = "HYQUERY\u0000".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] RESPONSE_MAGIC = "HYREPLY\u0000".getBytes(StandardCharsets.US_ASCII);
    private static final int REQUEST_LENGTH = 9;
    private static final byte TYPE_BASIC = 0;
    private final PluginConfig config;
    private final RewardExecutor rewardExecutor;
    private final HytaleLogger logger;
    private DatagramSocket socket;
    private Thread listenerThread;
    private volatile boolean running;

    public HyQueryResponder(PluginConfig config, RewardExecutor rewardExecutor, HytaleLogger logger) {
        this.config = config;
        this.rewardExecutor = rewardExecutor;
        this.logger = logger;
    }

    public void start() throws IOException {
        if (this.running) {
            throw new IllegalStateException("HyQuery responder is already running");
        }
        this.socket = new DatagramSocket(this.config.getHyQueryPort());
        this.running = true;
        this.listenerThread = new Thread(this::receiveLoop, "HyServers-HyQuery");
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
        ((HytaleLogger.Api)this.logger.atInfo()).log("HyQuery responder listening on UDP port %d", this.config.getHyQueryPort());
    }

    public void stop() {
        this.running = false;
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        if (this.listenerThread != null) {
            this.listenerThread.interrupt();
        }
        ((HytaleLogger.Api)this.logger.atInfo()).log("HyQuery responder stopped");
    }

    private void receiveLoop() {
        byte[] buffer = new byte[256];
        while (this.running) {
            try {
                byte[] magic;
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                this.socket.receive(packet);
                if (packet.getLength() < 9 || !Arrays.equals(magic = Arrays.copyOfRange(packet.getData(), packet.getOffset(), packet.getOffset() + 8), REQUEST_MAGIC)) continue;
                byte[] response = this.buildResponse();
                DatagramPacket reply = new DatagramPacket(response, response.length, packet.getAddress(), packet.getPort());
                this.socket.send(reply);
                if (!this.config.isDebug()) continue;
                ((HytaleLogger.Api)this.logger.atInfo()).log("[HyQuery] Responded to query from %s:%d", (Object)packet.getAddress().getHostAddress(), packet.getPort());
            }
            catch (SocketException e) {
                if (!this.running) continue;
                ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("Socket error in HyQuery responder");
            }
            catch (IOException e) {
                if (!this.running) continue;
                ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("I/O error in HyQuery responder");
            }
            catch (Exception e) {
                if (!this.running) continue;
                ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atWarning()).withCause((Throwable)e)).log("Error in HyQuery responder");
            }
        }
    }

    private byte[] buildResponse() {
        byte[] nameBytes = this.config.getServerName().getBytes(StandardCharsets.UTF_8);
        byte[] motdBytes = this.config.getServerMotd().getBytes(StandardCharsets.UTF_8);
        byte[] versionBytes = this.config.getServerVersion().getBytes(StandardCharsets.UTF_8);
        int onlinePlayers = this.rewardExecutor.getOnlinePlayerCount();
        int maxPlayers = this.config.getMaxPlayers();
        int serverPort = this.config.getServerPort();
        int size = 9 + (2 + nameBytes.length) + (2 + motdBytes.length) + 4 + 4 + 4 + (2 + versionBytes.length);
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.put(RESPONSE_MAGIC);
        buf.put((byte)0);
        this.writeLPString(buf, nameBytes);
        this.writeLPString(buf, motdBytes);
        buf.putInt(onlinePlayers);
        buf.putInt(maxPlayers);
        buf.putInt(serverPort);
        this.writeLPString(buf, versionBytes);
        return buf.array();
    }

    private void writeLPString(ByteBuffer buf, byte[] utf8Bytes) {
        buf.putShort((short)utf8Bytes.length);
        buf.put(utf8Bytes);
    }
}

