/*
 * Decompiled with CFR 0.152.
 */
package gg.hyservers.plugin.libs.gson.internal.bind;

import gg.hyservers.plugin.libs.gson.Gson;
import gg.hyservers.plugin.libs.gson.TypeAdapter;
import gg.hyservers.plugin.libs.gson.TypeAdapterFactory;
import gg.hyservers.plugin.libs.gson.internal.$Gson$Types;
import gg.hyservers.plugin.libs.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import gg.hyservers.plugin.libs.gson.reflect.TypeToken;
import gg.hyservers.plugin.libs.gson.stream.JsonReader;
import gg.hyservers.plugin.libs.gson.stream.JsonToken;
import gg.hyservers.plugin.libs.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class ArrayTypeAdapter<E>
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Type type = typeToken.getType();
            if (!(type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray())) {
                return null;
            }
            Type componentType = $Gson$Types.getArrayComponentType(type);
            TypeAdapter<?> componentTypeAdapter = gson.getAdapter(TypeToken.get(componentType));
            ArrayTypeAdapter arrayAdapter = new ArrayTypeAdapter(gson, componentTypeAdapter, $Gson$Types.getRawType(componentType));
            return arrayAdapter;
        }
    };
    private final Class<E> componentType;
    private final TypeAdapter<E> componentTypeAdapter;

    public ArrayTypeAdapter(Gson context, TypeAdapter<E> componentTypeAdapter, Class<E> componentType) {
        this.componentTypeAdapter = new TypeAdapterRuntimeTypeWrapper<E>(context, componentTypeAdapter, componentType);
        this.componentType = componentType;
    }

    @Override
    public Object read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        ArrayList<E> list = new ArrayList<E>();
        in.beginArray();
        while (in.hasNext()) {
            E instance = this.componentTypeAdapter.read(in);
            list.add(instance);
        }
        in.endArray();
        int size = list.size();
        if (this.componentType.isPrimitive()) {
            Object array = Array.newInstance(this.componentType, size);
            for (int i = 0; i < size; ++i) {
                Array.set(array, i, list.get(i));
            }
            return array;
        }
        Object[] array = (Object[])Array.newInstance(this.componentType, size);
        return list.toArray(array);
    }

    @Override
    public void write(JsonWriter out, Object array) throws IOException {
        if (array == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(array, i);
            this.componentTypeAdapter.write(out, value);
        }
        out.endArray();
    }
}

