/*
 * Decompiled with CFR 0.152.
 */
package gg.hyservers.plugin.config;

import com.hypixel.hytale.logger.HytaleLogger;
import gg.hyservers.plugin.config.PluginConfig;
import gg.hyservers.plugin.libs.gson.Gson;
import gg.hyservers.plugin.libs.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class ConfigManager {
    private final Path configDir;
    private final Path configFile;
    private final Gson gson;
    private final HytaleLogger logger;
    private PluginConfig config;

    public ConfigManager(Path configDir, HytaleLogger logger) {
        this.configDir = configDir;
        this.configFile = configDir.resolve("HyServersPlugin.json");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.logger = logger;
    }

    public void init() {
        try {
            if (!Files.exists(this.configDir, new LinkOption[0])) {
                Files.createDirectories(this.configDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atSevere()).withCause((Throwable)e)).log("Failed to create config directory: %s", (Object)this.configDir);
            this.config = new PluginConfig();
            return;
        }
        if (Files.exists(this.configFile, new LinkOption[0])) {
            this.load();
        } else {
            this.config = new PluginConfig();
            this.save();
            ((HytaleLogger.Api)this.logger.atInfo()).log("Default configuration created at %s", (Object)this.configFile);
        }
    }

    public void load() {
        try (BufferedReader reader = Files.newBufferedReader(this.configFile);){
            this.config = this.gson.fromJson((Reader)reader, PluginConfig.class);
            if (this.config == null) {
                this.config = new PluginConfig();
            }
            ((HytaleLogger.Api)this.logger.atInfo()).log("Configuration loaded from %s", (Object)this.configFile);
        }
        catch (IOException e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atSevere()).withCause((Throwable)e)).log("Failed to load configuration");
            this.config = new PluginConfig();
        }
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.configFile, new OpenOption[0]);){
            this.gson.toJson((Object)this.config, (Appendable)writer);
        }
        catch (IOException e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)this.logger.atSevere()).withCause((Throwable)e)).log("Failed to save configuration");
        }
    }

    public PluginConfig get() {
        return this.config;
    }
}

