/*
 * Decompiled with CFR 0.152.
 */
package gg.hyservers.plugin;

import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.HytaleServer;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.event.events.player.PlayerDisconnectEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerReadyEvent;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import gg.hyservers.plugin.commands.VoteCommand;
import gg.hyservers.plugin.config.ConfigManager;
import gg.hyservers.plugin.config.PluginConfig;
import gg.hyservers.plugin.network.HyQueryResponder;
import gg.hyservers.plugin.network.NotificationServer;
import gg.hyservers.plugin.network.PendingRewardPoller;
import gg.hyservers.plugin.network.StatusPinger;
import gg.hyservers.plugin.rewards.OfflineQueue;
import gg.hyservers.plugin.rewards.RewardExecutor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class HyServersPlugin
extends JavaPlugin {
    private ConfigManager configManager;
    private OfflineQueue offlineQueue;
    private RewardExecutor rewardExecutor;
    private NotificationServer notificationServer;
    private StatusPinger statusPinger;
    private PendingRewardPoller pendingRewardPoller;
    private HyQueryResponder hyQueryResponder;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> saveTask;
    private ScheduledFuture<?> cleanupTask;

    public HyServersPlugin(@Nonnull JavaPluginInit init) {
        super(init);
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("HyServersPlugin loaded");
    }

    protected void setup() {
        Path dataDir = Path.of("mods", "HyServers");
        this.configManager = new ConfigManager(dataDir, this.getLogger());
        this.configManager.init();
        PluginConfig cfg = this.configManager.get();
        this.offlineQueue = new OfflineQueue(dataDir, cfg.getMaxQueueSize(), cfg.getQueueExpiryHours(), this.getLogger());
        this.offlineQueue.load();
        this.rewardExecutor = new RewardExecutor(cfg, this.offlineQueue, this.getLogger());
        this.getCommandRegistry().registerCommand((AbstractCommand)new VoteCommand(cfg));
        this.getEventRegistry().registerGlobal(PlayerReadyEvent.class, event -> {
            String playerName = event.getPlayer().getDisplayName();
            this.rewardExecutor.trackPlayer(event.getPlayer());
            if (this.offlineQueue.hasPending(playerName)) {
                HytaleServer.SCHEDULED_EXECUTOR.schedule(() -> this.rewardExecutor.deliverPending(playerName), 2L, TimeUnit.SECONDS);
            }
        });
        this.getEventRegistry().registerGlobal(PlayerDisconnectEvent.class, event -> this.rewardExecutor.untrackPlayer(event.getPlayerRef().getUsername()));
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("HyServersPlugin setup complete");
    }

    protected void start() {
        PluginConfig cfg = this.configManager.get();
        if ("CHANGE_ME".equals(cfg.getSharedSecret()) || cfg.getSharedSecret().isBlank()) {
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("========================================");
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("  HyServersPlugin: Shared secret is not configured!");
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("  Edit your config and set a unique secret.");
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("  The notification server will NOT start.");
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("========================================");
            return;
        }
        this.notificationServer = new NotificationServer(cfg.getListenHost(), cfg.getListenPort(), cfg.getSharedSecret(), cfg.isDebug(), this.rewardExecutor, this.getLogger());
        try {
            this.notificationServer.start();
        }
        catch (IOException e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)this.getLogger().atSevere()).withCause((Throwable)e)).log("Failed to start notification server on port %d", cfg.getListenPort());
            return;
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "HyServers-Scheduler");
            t.setDaemon(true);
            return t;
        });
        this.saveTask = this.scheduler.scheduleWithFixedDelay(this.offlineQueue::save, 5L, 5L, TimeUnit.MINUTES);
        this.cleanupTask = this.scheduler.scheduleWithFixedDelay(this.offlineQueue::cleanExpired, 1L, 1L, TimeUnit.HOURS);
        if (cfg.isStatusPingEnabled() && !cfg.getServerId().isEmpty()) {
            this.statusPinger = new StatusPinger(cfg, this.rewardExecutor, this.getLogger());
            this.statusPinger.start(this.scheduler);
            ((HytaleLogger.Api)this.getLogger().atInfo()).log("Status pinger started (interval: %ds)", cfg.getStatusPingIntervalSeconds());
            this.pendingRewardPoller = new PendingRewardPoller(cfg, this.rewardExecutor, this.getLogger());
            this.pendingRewardPoller.start(this.scheduler);
            ((HytaleLogger.Api)this.getLogger().atInfo()).log("Pending reward poller started (interval: %ds)", cfg.getStatusPingIntervalSeconds());
        } else if (cfg.isStatusPingEnabled() && cfg.getServerId().isEmpty()) {
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("Status pings enabled but ServerId is empty \u2014 skipping. Set ServerId in your config.");
        }
        if (cfg.isHyQueryEnabled()) {
            this.hyQueryResponder = new HyQueryResponder(cfg, this.rewardExecutor, this.getLogger());
            try {
                this.hyQueryResponder.start();
            }
            catch (IOException e) {
                ((HytaleLogger.Api)((HytaleLogger.Api)this.getLogger().atSevere()).withCause((Throwable)e)).log("Failed to start HyQuery responder on port %d", cfg.getHyQueryPort());
            }
        }
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("HyServersPlugin started successfully");
    }

    protected void shutdown() {
        if (this.statusPinger != null) {
            this.statusPinger.stop();
        }
        if (this.pendingRewardPoller != null) {
            this.pendingRewardPoller.stop();
        }
        if (this.hyQueryResponder != null) {
            this.hyQueryResponder.stop();
        }
        if (this.notificationServer != null) {
            this.notificationServer.stop();
        }
        if (this.saveTask != null) {
            this.saveTask.cancel(false);
        }
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel(false);
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(3L, TimeUnit.SECONDS)) {
                    this.scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        if (this.offlineQueue != null) {
            this.offlineQueue.save();
        }
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("HyServersPlugin shut down");
    }
}

